<?php
session_start();
include '../db_connection.php';
include '../../sidebar.php';

// ইউজার চেক
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

// ডাটাবেজ থেকে due collections
$sql = "SELECT dc.id, dc.sale_id, dc.collected_amount, dc.collected_by, dc.collected_at, s.customer_name 
        FROM due_collections dc 
        JOIN sales s ON dc.sale_id = s.id
        ORDER BY dc.collected_at DESC";
$result = mysqli_query($con, $sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Due Collections Log</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container mt-4">
    <div class="card shadow">
        <div class="card-header bg-success text-white">
            <h4 class="mb-0">📋 Due Collections Log</h4>
        </div>
        <div class="card-body">

            <table class="table table-bordered table-striped table-hover">
                <thead class="table-success">
                    <tr>
                        <th>ID</th>
                        <th>Sale ID</th>
                        <th>Customer Name</th>
                        <th>Collected Amount (৳)</th>
                        <th>Collected By</th>
                        <th>Collected At</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($row = mysqli_fetch_assoc($result)): ?>
                        <tr>
                            <td><?= $row['id'] ?></td>
                            <td><?= $row['sale_id'] ?></td>
                            <td><?= htmlspecialchars($row['customer_name']) ?></td>
                            <td><?= number_format($row['collected_amount'], 2) ?></td>
                            <td><?= htmlspecialchars($row['collected_by']) ?></td>
                            <td><?= $row['collected_at'] ?></td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>

            <a href="due_list.php" class="btn btn-secondary">← Back to Due List</a>
        </div>
    </div>
</div>

<!-- Footer -->
<div class="mt-5">
    <?php include '../../footer.php'; ?>
</div>

<!-- JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
