<?php
include '../db_connection.php';

$con = new mysqli("localhost", "root", "", "shop");
$con->set_charset("utf8mb4");

$customerNameOrPhone = $_GET['query'] ?? '';

$customer = [];
$purchases = [];
$collections = [];

if (!empty($customerNameOrPhone)) {
    // Customer Info
    $stmt = $con->prepare("SELECT * FROM customer WHERE Customer_name = ? OR Customer_phone = ?");
    $stmt->bind_param("ss", $customerNameOrPhone, $customerNameOrPhone);
    $stmt->execute();
    $result = $stmt->get_result();
    $customer = $result->fetch_assoc();

    if ($customer) {
        $customer_id = $customer['id'];

        // Purchases
        $stmt2 = $con->prepare("SELECT grand_total, created_at FROM sales WHERE customer_id = ?");
        $stmt2->bind_param("i", $customer_id);
        $stmt2->execute();
        $result2 = $stmt2->get_result();
        $purchases = $result2->fetch_all(MYSQLI_ASSOC);

        // Collections
        $stmt3 = $con->prepare("SELECT collected_amount, collected_at FROM sales_collection WHERE customer_id = ?");
        $stmt3->bind_param("i", $customer_id);
        $stmt3->execute();
        $result3 = $stmt3->get_result();
        $collections = $result3->fetch_all(MYSQLI_ASSOC);
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Customer Summary</title>
    <style>
        body { font-family: sans-serif; margin: 40px; }
        h2 { text-align: center; }
        .section { margin-top: 30px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #999; padding: 8px; text-align: left; }
        .no-data { color: gray; font-style: italic; }
        @media print {
            #printBtn { display: none; }
        }
    </style>
</head>
<body>

<h2>Customer Summary Report</h2>

<?php if (!empty($customer)) : ?>
    <strong>Name:</strong> <?= htmlspecialchars($customer['Customer_name']) ?><br>
    <strong>Phone:</strong> <?= htmlspecialchars($customer['Customer_phone']) ?><br>
    <strong>Address:</strong> <?= htmlspecialchars($customer['Customer_address']) ?>

    <div class="section">
        <h3>Purchase History</h3>
        <?php if (!empty($purchases)) : ?>
            <table>
                <tr><th>Date</th><th>Amount (৳)</th></tr>
                <?php foreach ($purchases as $row): ?>
                    <tr>
                        <td><?= date("d-m-Y", strtotime($row['created_at'])) ?></td>
                        <td><?= number_format($row['grand_total'], 2) ?></td>
                    </tr>
                <?php endforeach; ?>
            </table>
        <?php else: ?>
            <p class="no-data">No purchase records found.</p>
        <?php endif; ?>
    </div>

    <div class="section">
        <h3>Due Collections</h3>
        <?php if (!empty($collections)) : ?>
            <table>
                <tr><th>Date</th><th>Amount Collected (৳)</th></tr>
                <?php foreach ($collections as $row): ?>
                    <tr>
                        <td><?= date("d-m-Y", strtotime($row['collected_at'])) ?></td>
                        <td><?= number_format($row['collected_amount'], 2) ?></td>
                    </tr>
                <?php endforeach; ?>
            </table>
        <?php else: ?>
            <p class="no-data">No collection records found.</p>
        <?php endif; ?>
    </div>

    <button id="printBtn" onclick="window.print()">🖨️ Print</button>

<?php else: ?>
    <p style="color:red;">No customer found for: <?= htmlspecialchars($customerNameOrPhone) ?></p>
<?php endif; ?>

</body>
</html>
