

<!----------------------------------Login------------------------------------>
<?php
include 'db_connection.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role']; // ✅ এখানে role সেভ করা হচ্ছে
$userId = $_SESSION['user_id'];


$isAdmin = ($_SESSION['role'] == 'admin');

?>

<!---------------------------------কন্টেন------------------------------------>
<?php

// Action handling
if (isset($_GET["action"])) {
    switch ($_GET["action"]) {
        case "delete":
            $id = intval($_GET["id"]);
            deleteSupplier($id);
            break;
        case "edit":
            $id = intval($_GET["id"]);
            showSuppliers($id);
            break;
        case "update":
            $id = intval($_GET["id"]);
            $Customer_name = ucwords($_GET["Customer_name"]);
            $Customer_phone = $_GET["Customer_phone"];
            $Customer_address = $_GET["Customer_address"];
            updateSupplier($id, $Customer_name, $Customer_phone, $Customer_address);
            break;
        case "cancel":
            showSuppliers(0);
            break;
        case "search":
            searchSupplier(strtoupper($_GET["text"]));
            break;
        default:
            showSuppliers(0);
            break;
    }
} else {
    showSuppliers(0);
}

// Function definitions
function showSuppliers($id) {
    global $con; // Use the global connection variable
    $seq_no = 0;
    $query = "SELECT * FROM customer";
    $result = mysqli_query($con, $query);
    while ($row = mysqli_fetch_array($result)) {
        $seq_no++;
        if ($row['id'] == $id) {
            showEditOptionsRow($seq_no, $row);
        } else {
            showSupplierRow($seq_no, $row);
        }
    }
}
function showEditOptionsRow($seq_no, $row) {
    ?>
    <tr>
        <td><?php echo $seq_no; ?></td>
       
        <td>
            <input type="text" class="form-control" value="<?php echo htmlspecialchars($row['Customer_name']); ?>" placeholder="Name" id="Customer_name">
        </td>
        <td>
            <input type="text" class="form-control" value="<?php echo htmlspecialchars($row['Customer_phone']); ?>" placeholder="Phone" id="Customer_phone">
        </td>
        <td>
            <input type="text" class="form-control" value="<?php echo htmlspecialchars($row['Customer_address']); ?>" placeholder="Customer Address" id="Customer_address">
        </td>
        <td>
            <button class="btn btn-success btn-sm" onclick="updateSupplier(<?php echo $row['id']; ?>);">
                <i class="fa fa-edit"></i>
            </button>
            <button class="btn btn-danger btn-sm" onclick="cancel();">
                <i class="fa fa-close"></i>
            </button>
        </td>
    </tr>
    <?php
}

function updateSupplier($id, $Customer_name, $Customer_phone, $Customer_address) {
    global $con;
    $query = "UPDATE customer SET Customer_name = '$Customer_name', Customer_phone = '$Customer_phone', Customer_address = '$Customer_address' WHERE id = $id";
    $result = mysqli_query($con, $query);
    if ($result) {
        showSuppliers(0);
    }
}

function deleteSupplier($id) {
    global $con;
    $query = "DELETE FROM customer WHERE id = $id";
    $result = mysqli_query($con, $query);
    if ($result) {
        showSuppliers(0);
    }
}

function searchSupplier($text) {
    global $con;
    $seq_no = 0;
    $query = "SELECT * FROM customer WHERE UPPER(Customer_name) LIKE '%$text%'";
    $result = mysqli_query($con, $query);
    while ($row = mysqli_fetch_array($result)) {
        $seq_no++;
        showSupplierRow($seq_no, $row);
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Customer Management</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script>
        function editSupplier(id) {
            window.location.href = "?action=edit&id=" + id; // Redirect to edit
        }

        function deleteSupplier(id) {
            if (confirm("Are you sure you want to delete this supplier?")) {
                window.location.href = "?action=delete&id=" + id; // Redirect to delete
            }
        }

        function updateSupplier(id) {
            const Customer_name = document.getElementById("Customer_name").value;
            const Customer_phone = document.getElementById("Customer_phone").value;
            const Customer_address = document.getElementById("Customer_address").value;

            window.location.href = "?action=update&id=" + id + "&Customer_name=" + encodeURIComponent(Customer_name) + "&Customer_phone=" + encodeURIComponent(Customer_phone) + "&Customer_address=" + encodeURIComponent(Customer_address);
        }

        function cancel() {
            window.location.href = "?action=cancel"; // Redirect to cancel
        }
    </script>
</head>
<body>
    <div class="container mt-5">
        <h2 class="mb-4">Customer Management</h2>
        <div class="mb-4">
            <form method="GET" action="">
                <input type="text" name="text" placeholder="Search by Customer Name" class="form-control" style="width: 300px; display: inline-block; margin-right: 10px;">
                <input type="hidden" name="action" value="search">
                <input type="submit" value="Search" class="btn btn-primary">
            </form>
        </div>
    </div>
</body>
</html>


