
function addProductToList(product) {
    const table = document.getElementById("productList");
    const row = table.insertRow();
    row.innerHTML = `
        <td><input type="hidden" name="product_id[]" value="${product.id}">${product.id}</td>
        <td><input type="hidden" name="product_description[]" value="${product.description}">${product.description}</td>
        <td><input type="number" name="quantity[]" value="1" min="1" onchange="updateTotal(this)"></td>
        <td><input type="hidden" name="price[]" value="${product.price}">${parseFloat(product.price).toFixed(2)}</td>
        <td class="total">${parseFloat(product.price).toFixed(2)}</td>
    `;
}

function scanProduct() {
    const scannedValue = document.getElementById("productScanner").value.trim();
    const productSelect = document.getElementById("productSelect");

    const options = Array.from(productSelect.options);
    let product = options.find(option => {
        try {
            const optionData = JSON.parse(option.value);
            return optionData && optionData.id == scannedValue;
        } catch (e) {
            console.error("Error parsing option data:", e);
            return false;
        }
    });

    if (product) {
        addProductToList(JSON.parse(product.value));
        document.getElementById("productScanner").value = '';
    } else {
        alert("Product not found. Please try again.");
    }
}