<?php
session_start();
include 'php/db_connection.php';
require('pdf/fpdf.php'); // Use regular FPDF, NOT tFPDF

if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit();
}

date_default_timezone_set('Asia/Dhaka');

// Get filter range from GET or default 30 days
$days = isset($_GET['days']) ? intval($_GET['days']) : 30;
$start_date = date('Y-m-d', strtotime("-$days days"));
$end_date = date('Y-m-d');

// Fetch overall summary
$summary_result = $con->query("
    SELECT COUNT(id) as total_sales,
           SUM(grand_total) as grand_total,
           SUM(collected) as total_collected,
           SUM(final_due) as total_due
    FROM sales
    WHERE created_at BETWEEN '$start_date 00:00:00' AND '$end_date 23:59:59'
");
$summary = $summary_result->fetch_assoc();

// Fetch sales grouped by day
$result = $con->query("
    SELECT DATE(created_at) as sale_date,
           COUNT(id) as total_sales,
           SUM(grand_total) as grand_total,
           SUM(collected) as total_collected,
           SUM(final_due) as total_due
    FROM sales
    WHERE created_at BETWEEN '$start_date 00:00:00' AND '$end_date 23:59:59'
    GROUP BY DATE(created_at)
    ORDER BY DATE(created_at) ASC
");

// Create PDF
class PDF extends FPDF {
    function Header(){
        $this->SetFont('Arial','B',14);
        $this->Cell(0,10,'Daily Sales Report',0,1,'C');
        $this->SetFont('Arial','',10);
        $this->Cell(0,5,'Period: '.$_GET['days'].' Days ('.date('d-m-Y', strtotime("-".$_GET['days']." days")).' to '.date('d-m-Y').')',0,1,'C');
        $this->Ln(5);
    }

    function Footer(){
        $this->SetY(-15);
        $this->SetFont('Arial','I',8);
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }

    function SummaryTable($summary){
        $this->SetFont('Arial','B',12);
        $this->Cell(0,10,'Summary',0,1,'L');
        $this->SetFont('Arial','',10);
        $this->Cell(50,8,'Total Sales',1,0,'C');
        $this->Cell(50,8,'Grand Total',1,0,'C');
        $this->Cell(50,8,'Collected',1,0,'C');
        $this->Cell(50,8,'Due',1,1,'C');

        $this->Cell(50,8,$summary['total_sales'],1,0,'C');
        $this->Cell(50,8,number_format($summary['grand_total'],2),1,0,'C');
        $this->Cell(50,8,number_format($summary['total_collected'],2),1,0,'C');
        $this->Cell(50,8,number_format($summary['total_due'],2),1,1,'C');
        $this->Ln(5);
    }

    function DailyDetailHeader(){
        $this->SetFont('Arial','B',10);
        $this->Cell(30,8,'Date',1,0,'C');
        $this->Cell(30,8,'Total Sales',1,0,'C');
        $this->Cell(40,8,'Grand Total',1,0,'C');
        $this->Cell(40,8,'Collected',1,0,'C');
        $this->Cell(40,8,'Due',1,1,'C');
    }
}

$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();

// Add summary
$pdf->SummaryTable($summary);

// Add daily detail
$pdf->DailyDetailHeader();
$pdf->SetFont('Arial','',10);

while($row = $result->fetch_assoc()){
    $pdf->Cell(30,8,date('d-m-Y', strtotime($row['sale_date'])),1,0,'C');
    $pdf->Cell(30,8,$row['total_sales'],1,0,'C');
    $pdf->Cell(40,8,number_format($row['grand_total'],2),1,0,'C');
    $pdf->Cell(40,8,number_format($row['total_collected'],2),1,0,'C');
    $pdf->Cell(40,8,number_format($row['total_due'],2),1,1,'C');
}

$pdf->Output('I','daily_sales_report.pdf');
