<!----------------------------------Login------------------------------------>
<?php
include 'php/db_connection.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role']; // ✅ এখানে role সেভ করা হচ্ছে
$userId = $_SESSION['user_id'];


$isAdmin = ($_SESSION['role'] == 'admin');

?>

<!---------------------------------কন্টেন------------------------------------>
<?php
$con->set_charset("utf8mb4");

$customer = null;
$purchases = [];
$collections = [];

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $search = "%" . $_POST['search'] . "%";

    $stmt = $con->prepare("SELECT * FROM customer WHERE customer_name LIKE ? OR customer_phone LIKE ?");
    $stmt->bind_param("ss", $search, $search);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $customer = $result->fetch_assoc();
        $customer_id = $customer['id'];

        // Get sales (purchases)
        $stmt_sales = $con->prepare("SELECT id, created_at, grand_total, collected FROM sales WHERE customer_id = ?");
        $stmt_sales->bind_param("i", $customer_id);
        $stmt_sales->execute();
        $sales_result = $stmt_sales->get_result();
        while ($row = $sales_result->fetch_assoc()) {
            $purchases[] = $row;

            // Add to collections if collected > 0
            if ($row['collected'] > 0) {
                $collections[] = [
                    'collected_at' => $row['created_at'],
                    'collected_amount' => $row['collected']
                ];
            }
        }

        // Get due_collections
        $stmt_dues = $con->prepare("SELECT collected_at, collected_amount FROM due_collections WHERE customer_id = ?");
        $stmt_dues->bind_param("i", $customer_id);
        $stmt_dues->execute();
        $dues_result = $stmt_dues->get_result();
        while ($row = $dues_result->fetch_assoc()) {
            $collections[] = $row;
        }

        // Sort all collections by date
        usort($collections, function($a, $b) {
            return strtotime($a['collected_at']) - strtotime($b['collected_at']);
        });
    } else {
        echo "<p style='color:red;text-align:center;'>কোনো কাস্টমার পাওয়া যায়নি</p>";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Customer Summary</title>
    <style>
        body { font-family: kalpurush, sans-serif; margin: 20px; background: #f9f9f9; }
        form { text-align: center; margin-bottom: 20px; }
        input[type="text"] { padding: 8px; width: 300px; font-size: 16px; }
        input[type="submit"] { padding: 8px 20px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 30px; }
        th, td { border: 1px solid #ccc; padding: 8px; text-align: left; }
        th { background-color: #eee; }
        h2, h3 { background: #ddd; padding: 10px; }
    </style>
</head>
<body>

<form method="POST">
    <input type="text" name="search" placeholder="কাস্টমারের নাম বা মোবাইল দিন" required>
    <input type="submit" value="সার্চ করুন">
</form>

<?php if ($customer): ?>
    <h2>কাস্টমারের তথ্য</h2>
    <p><strong>নাম:</strong> <?= htmlspecialchars($customer['Customer_name']) ?></p>
    <p><strong>মোবাইল:</strong> <?= htmlspecialchars($customer['Customer_phone']) ?></p>
    <p><strong>ঠিকানা:</strong> <?= htmlspecialchars($customer['Customer_address']) ?></p>

    <h3>পারচেজের হিস্টোরি</h3>
    <table>
        <tr>
            <th>তারিখ</th>
            <th>পরিমাণ (৳)</th>
        </tr>
        <?php 
        $total_grand = 0;
        foreach ($purchases as $row): 
            $total_grand += $row['grand_total'];
        ?>
        <tr>
            <td><?= date("d-m-Y", strtotime($row['created_at'])) ?></td>
            <td><?= number_format($row['grand_total'], 2) ?></td>
        </tr>
        <?php endforeach; ?>
        <tr>
            <td><strong>মোট</strong></td>
            <td><strong><?= number_format($total_grand, 2) ?> ৳</strong></td>
        </tr>
    </table>

    <h3>জমার হিস্টোরি</h3>
    <table>
        <tr>
            <th>তারিখ</th>
            <th>পরিমাণ (৳)</th>
        </tr>
        <?php 
        $total_collected = 0;
        foreach ($collections as $row): 
            $total_collected += $row['collected_amount'];
        ?>
        <tr>
            <td><?= date("d-m-Y", strtotime($row['collected_at'])) ?></td>
            <td><?= number_format($row['collected_amount'], 2) ?></td>
        </tr>
        <?php endforeach; ?>
        <tr>
            <td><strong>মোট</strong></td>
            <td><strong><?= number_format($total_collected, 2) ?> ৳</strong></td>
        </tr>
    </table>

    <h3>মোট হিসাব</h3>
    <p><strong>মোট ক্রয়:</strong> <?= number_format($total_grand, 2) ?> ৳</p>
    <p><strong>মোট জমা:</strong> <?= number_format($total_collected, 2) ?> ৳</p>
    <p><strong>বর্তমান বকেয়া:</strong> <?= number_format($total_grand - $total_collected, 2) ?> ৳</p>
<?php endif; ?>

</body>
</html>








<?php

$con = new mysqli("localhost", "root", "", "shop");
$con->set_charset("utf8mb4");

$customerNameOrPhone = $_GET['query'] ?? '';

$customer = [];
$purchases = [];
$collections = [];

if (!empty($customerNameOrPhone)) {
    // Customer Info
    $stmt = $con->prepare("SELECT * FROM customer WHERE Customer_name = ? OR Customer_phone = ?");
    $stmt->bind_param("ss", $customerNameOrPhone, $customerNameOrPhone);
    $stmt->execute();
    $result = $stmt->get_result();
    $customer = $result->fetch_assoc();

    if ($customer) {
        $customer_id = $customer['id'];

        // Purchases
        $stmt2 = $con->prepare("SELECT grand_total, created_at FROM sales WHERE customer_id = ?");
        $stmt2->bind_param("i", $customer_id);
        $stmt2->execute();
        $result2 = $stmt2->get_result();
        $purchases = $result2->fetch_all(MYSQLI_ASSOC);

        // Collections
        $stmt3 = $con->prepare("SELECT collected_amount, collected_at FROM sales_collection WHERE customer_id = ?");
        $stmt3->bind_param("i", $customer_id);
        $stmt3->execute();
        $result3 = $stmt3->get_result();
        $collections = $result3->fetch_all(MYSQLI_ASSOC);
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Customer Summary</title>
    <style>
        body { font-family: sans-serif; margin: 40px; }
        h2 { text-align: center; }
        .section { margin-top: 30px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #999; padding: 8px; text-align: left; }
        .no-data { color: gray; font-style: italic; }
        @media print {
            #printBtn { display: none; }
        }
    </style>
</head>
<body>

<h2>Customer Summary Report</h2>

<?php if (!empty($customer)) : ?>
    <strong>Name:</strong> <?= htmlspecialchars($customer['Customer_name']) ?><br>
    <strong>Phone:</strong> <?= htmlspecialchars($customer['Customer_phone']) ?><br>
    <strong>Address:</strong> <?= htmlspecialchars($customer['Customer_address']) ?>

    <div class="section">
        <h3>Purchase History</h3>
        <?php if (!empty($purchases)) : ?>
            <table>
                <tr><th>Date</th><th>Amount (৳)</th></tr>
                <?php foreach ($purchases as $row): ?>
                    <tr>
                        <td><?= date("d-m-Y", strtotime($row['created_at'])) ?></td>
                        <td><?= number_format($row['grand_total'], 2) ?></td>
                    </tr>
                <?php endforeach; ?>
            </table>
        <?php else: ?>
            <p class="no-data">No purchase records found.</p>
        <?php endif; ?>
    </div>

    <div class="section">
        <h3>Due Collections</h3>
        <?php if (!empty($collections)) : ?>
            <table>
                <tr><th>Date</th><th>Amount Collected (৳)</th></tr>
                <?php foreach ($collections as $row): ?>
                    <tr>
                        <td><?= date("d-m-Y", strtotime($row['collected_at'])) ?></td>
                        <td><?= number_format($row['collected_amount'], 2) ?></td>
                    </tr>
                <?php endforeach; ?>
            </table>
        <?php else: ?>
            <p class="no-data">No collection records found.</p>
        <?php endif; ?>
    </div>

    <button id="printBtn" onclick="window.print()">🖨️ Print</button>

<?php else: ?>
    <p style="color:red;">No customer found for: <?= htmlspecialchars($customerNameOrPhone) ?></p>
<?php endif; ?>

</body>
</html>

