
<?php
session_start();
include 'php/db_connection.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role']; // ✅ এখানে role সেভ করা হচ্ছে


$isAdmin = ($_SESSION['role'] == 'admin');

?>


<?php include 'heade.php';?>
<?php include 'sidebar.php';?>

<?php
// Function to get suppliers for dropdown
function getSuppliers() {
    global $con;
    $result = mysqli_query($con, "SELECT id, name FROM suppliers");
    return $result;
}

// Handle Add Product Form Submission
if (isset($_POST['addProduct'])) {
    $productName = $_POST['productName'];
    $productId = $_POST['productId'];
    $price = $_POST['price'];
    $purchasePrice = $_POST['purchasePrice'];
    $supplierId = $_POST['supplier'];

    // Check if the product already exists
    $checkQuery = "SELECT * FROM product_cat WHERE Product_id = '$productId'";
    $checkResult = mysqli_query($con, $checkQuery);
    if (mysqli_num_rows($checkResult) > 0) {
        echo "<div class='alert alert-danger'>Product with this ID already exists!</div>";
    } else {
        $sql = "INSERT INTO product_cat (Product_name, Product_id, price, purchase_price, supplier_id) 
                VALUES ('$productName', '$productId', '$price', '$purchasePrice', '$supplierId')";
        if (mysqli_query($con, $sql)) {
            echo "<div class='success-message'>Product added successfully!</div>";
            echo "<script>setTimeout(function(){ location.reload(); }, 2000);</script>"; // Reload after 2 seconds
        } else {
            echo "<div class='alert alert-danger'>Error: " . mysqli_error($con) . "</div>";
        }
    }
}

// Handle Delete Product
if (isset($_POST['action']) && $_POST['action'] == 'deleteProduct') {
    $productId = $_POST['id'];
    $sql = "DELETE FROM product_cat WHERE id = $productId";
    if (mysqli_query($con, $sql)) {
        echo json_encode(['status' => 'success', 'message' => 'Product deleted successfully!']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to delete product.']);
    }
    exit();
}

// Pagination variables
$limit = 5;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Fetch product data with pagination and supplier info
function getProductWithSupplier($offset, $limit) {
    global $con;
    $result = mysqli_query($con, "
        SELECT pc.id, pc.Product_name, pc.Product_id, pc.price, pc.purchase_price, 
               s.name AS supplier_name, 
               SUM(p.quantity) AS total_quantity, 
               SUM(p.quantity * pc.price) AS total_price,
               SUM(p.quantity * pc.purchase_price) AS total_purchase_price  -- New column for Purchase Price × Total Quantity
        FROM product_cat pc
        LEFT JOIN suppliers s ON pc.supplier_id = s.id
        LEFT JOIN product p ON pc.Product_id = p.product_id
        GROUP BY pc.id, pc.Product_name, pc.Product_id, pc.price, pc.purchase_price, s.name
        LIMIT $offset, $limit
    ");
    return $result;
}

// Count total products for pagination
function getTotalProducts() {
    global $con;
    $result = mysqli_query($con, "SELECT COUNT(*) as count FROM product_cat");
    return mysqli_fetch_assoc($result)['count'];
}

$totalProducts = getTotalProducts();
$totalPages = ceil($totalProducts / $limit);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>product</title>
    <link rel="stylesheet" href="css/cusatom.css"> <!-- Assuming you have a separate CSS file -->
</head>
<body>
   
    <script>
        function deleteProduct(productId) {
            if (confirm("Are you sure you want to delete this product?")) {
                var xhr = new XMLHttpRequest();
                xhr.open("POST", "", true);  
                xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                xhr.onreadystatechange = function () {
                    if (xhr.readyState == 4 && xhr.status == 200) {
                        var response = JSON.parse(xhr.responseText);
                        if (response.status === 'success') {
                            alert(response.message);
                            location.reload();  // This will reload the page after successful deletion
                        } else {
                            alert(response.message);
                        }
                    }
                };
                xhr.send("action=deleteProduct&id=" + productId);
            }
        }
    </script>
</head>
<body>
    
    <!-- Add Product Form -->
    <div style="margin-top: 20px;">
        <h2>Add New Product</h2>
        <form method="POST" action="">
            <div>
                <label for="productName">Product Name:</label>
                <input type="text" id="productName" name="productName" required>
            </div>
            <div>
                <label for="productId">Product ID:</label>
                <input type="text" id="productId" name="productId" required>
            </div>
            <div>
                <label for="price">Price:</label>
                <input type="number" id="price" name="price" step="0.01" required>
            </div>
            <div>
                <label for="purchasePrice">Purchase Price:</label>
                <input type="number" id="purchasePrice" name="purchasePrice" step="0.01" required>
            </div>
            <div>
                <label for="supplier">Supplier:</label>
                <select id="supplier" name="supplier" required>
                    <option value="">Select Supplier</option>
                    <?php
                    $suppliers = getSuppliers();
                    while ($supplier = mysqli_fetch_assoc($suppliers)) {
                        echo "<option value='{$supplier['id']}'>{$supplier['name']}</option>";
                    }
                    ?>
                </select>
            </div>
            <button type="submit" name="addProduct"><i class="bi bi-plus-square"></i></button>
        </form>
    </div>


<!------------------------------------------পেইজ নেভসহ নতুন কোড---------------------------------------------------->
<?php
// Set the number of records per page
$records_per_page = 5;

// Find out the total number of records
$total_sql = "SELECT COUNT(*) FROM product_cat";
$total_result = $con->query($total_sql);
$total_row = $total_result->fetch_row();
$total_records = $total_row[0];

// Calculate the total number of pages
$total_pages = ceil($total_records / $records_per_page);

// Get the current page number from URL, default to 1 if not set
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;

// Calculate the starting record for the current page
$start_from = ($page - 1) * $records_per_page;

// Fetch the sales records for the current page
$sql = "SELECT * 
        FROM product_cat 
        ORDER BY Product_name DESC 
        LIMIT $start_from, $records_per_page";
$result = $con->query($sql);
?>

    <h5>Product Cataory</h5>

    <table>
        <tr>
                <th>Sl No</th>
                <th>Product Name</th>
                <th>Product ID</th>
                <th>Price</th>
                <th>Purchase Price</th>
                <th>Supplier Name</th>
                <th>Total Quantity</th>
                <th>Total Price</th>
                <th>Total Purchase Price</th> <!-- New Column -->
               <th colspan="2">Action</th>
        </tr>

        <?php 
         $result = getProductWithSupplier($offset, $limit);
        if ($result->num_rows > 0): ?>
            
            <?php while ($row = $result->fetch_assoc()): ?>
                
                <tr>
                    <td><?php echo $row['id']; ?></td>
                    <td><?php echo htmlspecialchars($row['Product_name']); ?></td>
                    <td><?php echo htmlspecialchars($row['Product_id']); ?></td>
                    <td><?php echo htmlspecialchars($row['price']); ?></td>
                    <td><?php echo htmlspecialchars($row['purchase_price']); ?></td>
                    <td><?php echo htmlspecialchars($row['supplier_name']); ?></td>
                    <td><?php echo htmlspecialchars($row['total_quantity']); ?></td>
                    <td><?php echo htmlspecialchars($row['total_price']); ?></td>
                    <td><?php echo htmlspecialchars($row['total_purchase_price']); ?></td> <!-- Display the new column -->
                    
                    <td>
                        <a href="add_product.php?category=<?= urlencode($row['Product_id']) ?>" class="btn btn-primary"><i class="bi bi-plus-square"></i></a>
                    </td>
                    <td>
                        <button class="action-button" onclick="window.open('barcode_labels.php?search=<?= $row['Product_id'] ?>', '_blank')"><i class="fas fa-barcode"></i></button>
                    </td>
                    <td>
                    <button class='delete-button' onclick='deleteProduct(<?= $row["id"] ?>)'><i class="bi bi-trash"></i></button>
                    </td>
                </tr>
            <?php endwhile; ?>
        <?php else: ?>
            <tr>
                <td colspan="8">No recent sales found</td>
            </tr>
        <?php endif; ?>
    </table>

    <!-- Pagination Links -->
    <div class="pagination">
        <?php if ($page > 1): ?>
            <a href="?page=<?php echo $page - 1; ?>">Prev</a>
        <?php endif; ?>

        <!-- Display Current Page Range (ex: 1-5, 6-10, etc.) -->
        <span class="active">Page <?php echo $page; ?> of <?php echo $total_pages; ?></span>

        <?php if ($page < $total_pages): ?>
            <a href="?page=<?php echo $page + 1; ?>">Next</a>
        <?php endif; ?>
    </div>

    <?php
    $con->close();
    include 'footer.php';
    ?>
