
<!----------------------------------Login------------------------------------>
<?php
include 'php/db_connection.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role']; // ✅ এখানে role সেভ করা হচ্ছে
$userId = $_SESSION['user_id'];


$isAdmin = ($_SESSION['role'] == 'admin');

?>

<!---------------------------------কন্টেন------------------------------------>
<?php

// Initialize variables for totals
$total_purchase_price_today = 0;
$total_grand_total_today = 0;
$total_difference_today = 0;

$total_purchase_price_7_days = 0;
$total_grand_total_7_days = 0;
$total_difference_7_days = 0;

$total_purchase_price_30_days = 0;
$total_grand_total_30_days = 0;
$total_difference_30_days = 0;

// Query for today (purchase_price and grand_total)
$query_today = "
    SELECT SUM(s.purchase_price) AS total_purchase_price, SUM(sa.grand_total) AS total_grand_total
    FROM sales_items s
    JOIN sales sa ON s.sales_id = sa.id
    WHERE DATE(sa.created_at) = CURDATE()
";
$result_today = mysqli_query($con, $query_today);
if ($row_today = mysqli_fetch_assoc($result_today)) {
    $total_purchase_price_today = $row_today['total_purchase_price'] ?? 0;
    $total_grand_total_today = $row_today['total_grand_total'] ?? 0;
    $total_difference_today = $total_grand_total_today - $total_purchase_price_today;
}

// Query for last 7 days (purchase_price and grand_total)
$query_7_days = "
    SELECT SUM(s.purchase_price) AS total_purchase_price, SUM(sa.grand_total) AS total_grand_total
    FROM sales_items s
    JOIN sales sa ON s.sales_id = sa.id
    WHERE sa.created_at >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)
";
$result_7_days = mysqli_query($con, $query_7_days);
if ($row_7_days = mysqli_fetch_assoc($result_7_days)) {
    $total_purchase_price_7_days = $row_7_days['total_purchase_price'] ?? 0;
    $total_grand_total_7_days = $row_7_days['total_grand_total'] ?? 0;
    $total_difference_7_days = $total_grand_total_7_days - $total_purchase_price_7_days;
}

// Query for last 30 days (purchase_price and grand_total)
$query_30_days = "
    SELECT SUM(s.purchase_price) AS total_purchase_price, SUM(sa.grand_total) AS total_grand_total
    FROM sales_items s
    JOIN sales sa ON s.sales_id = sa.id
    WHERE sa.created_at >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)
";
$result_30_days = mysqli_query($con, $query_30_days);
if ($row_30_days = mysqli_fetch_assoc($result_30_days)) {
    $total_purchase_price_30_days = $row_30_days['total_purchase_price'] ?? 0;
    $total_grand_total_30_days = $row_30_days['total_grand_total'] ?? 0;
    $total_difference_30_days = $total_grand_total_30_days - $total_purchase_price_30_days;
}

// Close the database connection
mysqli_close($con);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sales Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 80%;
            margin: 20px auto;
            background-color: #fff;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h1 {
            text-align: center;
            color: #333;
        }
        .report-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .report-table th, .report-table td {
            padding: 12px;
            text-align: center;
            border: 1px solid #ddd;
        }
        .report-table th {
            background-color: #f2f2f2;
            color: #333;
        }
        .report-table td {
            background-color: #fafafa;
        }
        .highlight {
            background-color: #ffeb3b;
        }
    </style>
</head>
