
<!----------------------------------Login------------------------------------>
<?php
session_start();
include 'php/db_connection.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role']; // ✅ এখানে role সেভ করা হচ্ছে
$userId = $_SESSION['user_id'];


$isAdmin = ($_SESSION['role'] == 'admin');

?>

<!---------------------------------কন্টেন------------------------------------>
<?php

// Query for sum of purchase_price for last 7 days (assuming `created_at` is the correct column name)
$seven_days_query = "SELECT SUM(purchase_price) AS total_purchase_price FROM sales_items WHERE created_at >= NOW() - INTERVAL 7 DAY";
$seven_days_result = $con->query($seven_days_query);
$seven_days_total = 0;
if ($seven_days_result->num_rows > 0) {
    $row = $seven_days_result->fetch_assoc();
    $seven_days_total = $row['total_purchase_price'];
}

// Query for sum of purchase_price for last 30 days (assuming `created_at` is the correct column name)
$thirty_days_query = "SELECT SUM(purchase_price) AS total_purchase_price FROM sales_items WHERE created_at >= NOW() - INTERVAL 30 DAY";
$thirty_days_result = $con->query($thirty_days_query);
$thirty_days_total = 0;
if ($thirty_days_result->num_rows > 0) {
    $row = $thirty_days_result->fetch_assoc();
    $thirty_days_total = $row['total_purchase_price'];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sales Items Purchase Price Report</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <div class="container">
        <h2>Sales Items Purchase Price Report</h2>

        <!-- Last 7 Days Report -->
        <h3>Total Purchase Price for Last 7 Days</h3>
        <p>₹ <?php echo number_format($seven_days_total, 2); ?></p>

        <!-- Last 30 Days Report -->
        <h3>Total Purchase Price for Last 30 Days</h3>
        <p>₹ <?php echo number_format($thirty_days_total, 2); ?></p>

    </div>
</body>
</html>

<?php
// Close the database connection
$con->close();
?>
